<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Undangan</title>
</head>

<body>
    <style>
        .detail,
        tr,
        td {
            border: 0 !important;
            border-spacing: 0 !important;
        }

        .daftarHadir {
            width: 100%;
            max-width: 1300px;
            border-collapse: collapse;
            font-size: 12px;
        }


        .borderline {
            border: 1px solid black !important;
        }

        th,
        td {
            padding: 0px;
            text-align: left;
        }

        th {
            background-color: #f4f4f4;
        }

        h2 {
            text-align: center;
            margin-bottom: 10px;
        }

        h3 {
            text-align: center;
            margin-bottom: 10px;
        }

        p {
            text-align: center;
            margin-bottom: 20px;
            font-size: 14px;
        }

        .nomer {
            width: 2%;
            text-align: center;
        }

        .tanggal {
            width: 7%;
        }

        .agenda {
            width: 20%;
        }

        .ruangan {
            width: 15%;
        }

        .pukul {
            width: 3%;
        }

        .peserta {
            width: 20%;
        }

        .keterangan {
            width: 20%;
        }

        .metode {
            width: 10%;
        }
    </style>
    <h2><u> UNDANGAN</u></h2>
    <p>Nomor: U-{{$agendaRapat->nomer}}/{{$departemen->kode}}/{{\Carbon\Carbon::parse($agendaRapat->tanggal)->locale('id')->translatedFormat('m/Y') }}</p>
    <div style="display:flex; flex-direction: row; align-items: center;justify-content: center;">
        <div>
            <table class="detail" style="width:100%">
                <tr>
                    <td width="20%"></td>
                    <td width="15%" style="vertical-align: top;">Kepada Yth.</td>
                    <td width="2%" style="vertical-align: top;">:</td>
                    <td style="vertical-align: top;">

                        <?php
                        $content = '';
                        $number = 0;
                        foreach ($pesertaRapat as $index => $peserta) {
                            if (!str_contains($content, $peserta->user->departemen->name)) {
                                $number++;
                                $content .= $number . ". " . $peserta->user->departemen->name . "<br>";
                            }
                        }
                        echo $content;
                        ?>

                    </td>
                </tr>
                <tr>
                    <td width="20%"></td>
                    <td width="15%">Dari</td>
                    <td width="2%">:</td>
                    <td>{{$departemen->name}}</td>
                </tr>
                <tr>
                    <td width="20%"></td>
                    <td width="15%">Perihal</td>
                    <td width="2%">:</td>
                    <td>{{$agendaRapat->judul}}</td>
                </tr>
            </table>


            <hr style="display:block; height: 1px; background: transparent; width: 100%; border:none; border-top: solid 1px #000;">
            <hr style="display:block; height: 1px; background: transparent; width: 100%; border:none; border-top: solid 5px #000;">

            Dalam rangka Pembahasan "{{$agendaRapat->judul}}" dengan ini kami mengundang Bapak/Ibu untuk dapat hadir pada:
            <br>
            <br>
            <table class="detail" style="width:100%">
                <tr>
                    <td width="5%"></td>
                    <td width="15%">Hari/Tanggal</td>
                    <td width="2%">:</td>
                    <td>{{ \Carbon\Carbon::parse($agendaRapat->tanggal)->locale('id')->translatedFormat('l, d F Y') }}</td>
                </tr>
                <tr>
                    <td width="5%"></td>
                    <td width="2%">Waktu</td>
                    <td>:</td>
                    <td>{{ \Carbon\Carbon::createFromFormat('H:i:s', $agendaRapat->mulai)->format('h:i A') }} s.d. {{ \Carbon\Carbon::createFromFormat('H:i:s', $agendaRapat->selesai)->format('h:i A') }}</td>
                </tr>
                <tr>
                    <td width="5%"></td>
                    <td width="15%">Tempat</td>
                    <td width="2%">:</td>
                    <td>{{ $agendaRapat->ruangan->name }}</td>
                </tr>
                <tr>
                    <td width="5%"></td>
                    <td width="15%">Agenda</td>
                    <td width="2%">:</td>
                    <td>{{ $agendaRapat->judul }}</td>
                </tr>
            </table>
            <br>
            Demikian disampaikan, atas kehadiran Bapak/Ibu diucapkan terimakasih.
            <br>
            <br>
            <br>
            <table class="detail" style="width:100%">
                <tr>
                    <td style="width: 60%;"></td>
                    <td>Jakarta,{{ \Carbon\Carbon::parse($agendaRapat->accepted)->locale('id')->translatedFormat('d F Y') }}</td>
                </tr>
                <tr>
                    <td style="width: 60%;"></td>
                    <td><br><br><br></td>
                </tr>
                <tr>
                    <td style="width: 60%;"></td>
                    <td><b>{{$creator->name}}<b></td>
                </tr>
                <tr>
                    <td style="width: 60%;"></td>
                    <td>{{$departemen->name}}</td>
                </tr>
            </table>
        </div>
    </div>
</body>

</html>