@php
use Filament\Infolists\Components\TextEntry\TextEntrySize;
use Filament\Support\Enums\Alignment;
use Filament\Support\Enums\FontFamily;
use Filament\Support\Enums\FontWeight;
use Filament\Support\Enums\IconPosition;
@endphp

<div>
    <strong class="text-md">
        {{ $getLabel() }}:
    </strong>
    <br>
    <span class="text-sm flex-end">
        @php
        $alignment = $getAlignment();
        $isBadge = $isBadge();
        $isBulleted = $isBulleted();
        $iconPosition = $getIconPosition();
        $isListWithLineBreaks = $isListWithLineBreaks();
        $isLimitedListExpandable = $isLimitedListExpandable();
        $isProse = $isProse();
        $isMarkdown = $isMarkdown();
        $url = $getUrl();
        $formatState = $formatState($getState());
        $icon = $getIcon($state);
        $iconColor = $getIconColor($state);

        $iconClasses = \Illuminate\Support\Arr::toCssClasses([
        'fi-in-text-item-icon h-5 w-5 shrink-0',
        match ($iconColor) {
        'gray', null => 'text-gray-400 dark:text-gray-500',
        default => 'text-custom-500',
        },
        ]);

        $iconStyles = \Illuminate\Support\Arr::toCssStyles([
        \Filament\Support\get_color_css_variables(
        $iconColor,
        shades: [500],
        alias: 'infolists::components.text-entry.item.icon',
        ) => $iconColor !== 'gray',
        ]);

        @endphp
        @if($getState() != null)
        <a
            @if($url !=null )
            href="{{$url}}"
            target="_blank"
            @endif
            class="inline-flex"
            @if($icon!=null)
            style="padding-top: 3px;"
            @endif>
            @if($icon != null)
            <div style="margin-right: 5px;">
                <x-filament::icon
                    :icon="$icon"
                    :class="$iconClasses"
                    :style="$iconStyles" />
            </div>
            @endif
            {{ $formatState }}
        </a>
        @else
        -
        @endif
    </span>
    <span class="text-sm text-gray-500">
        @if ($getState() === null)
        {{ $getPlaceholder() }}
        @endif
    </span>
</div>