<?php

namespace App\Providers\Filament;

use Filament\Http\Middleware\Authenticate;
use Filament\Http\Middleware\AuthenticateSession;
use Filament\Http\Middleware\DisableBladeIconComponents;
use Filament\Http\Middleware\DispatchServingFilamentEvent;
use Filament\Navigation\NavigationGroup;
use Filament\Pages;
use App\Filament\App\Auth\Login;
use App\Filament\App\Pages\EditProfile as PagesEditProfile;
use App\Filament\App\Resources\AgendaRapatResource\Pages\RapatTerjadwal;
use Filament\Panel;
use Filament\PanelProvider;
use Filament\Support\Colors\Color;
use Filament\Widgets;
use Illuminate\Cookie\Middleware\AddQueuedCookiesToResponse;
use Illuminate\Cookie\Middleware\EncryptCookies;
use Illuminate\Foundation\Http\Middleware\VerifyCsrfToken;
use Illuminate\Routing\Middleware\SubstituteBindings;
use Illuminate\Session\Middleware\StartSession;
use Illuminate\View\Middleware\ShareErrorsFromSession;
use Filament\Navigation\MenuItem;
use Filament\Navigation\NavigationItem;
use Illuminate\Support\Facades\Auth;

class AppPanelProvider extends PanelProvider
{
    public function panel(Panel $panel): Panel
    {
        return $panel
            ->id('app')
            ->path('app')
            ->login(Login::class)
            ->brandLogo(fn() => view('filament.app.pages.logo-light'))
            ->darkModeBrandLogo(fn() => view('filament.app.pages.logo-dark'))
            ->colors([
                'primary' => Color::Sky,
            ])
            ->discoverResources(in: app_path('Filament/App/Resources'), for: 'App\\Filament\\App\\Resources')
            ->discoverPages(in: app_path('Filament/App/Pages'), for: 'App\\Filament\\App\\Pages')
            ->pages([
                Pages\Dashboard::class,
            ])
            ->userMenuItems([
                'profile' => MenuItem::make()->url(fn(): string => PagesEditProfile::getUrl())
            ])
            ->discoverWidgets(in: app_path('Filament/App/Widgets'), for: 'App\\Filament\\App\\Widgets')
            ->widgets([
                //Widgets\AccountWidget::class,
                // Widgets\FilamentInfoWidget::class,
            ])
            ->breadcrumbs(false)
            ->navigationItems([
                NavigationItem::make('rapat-terjadwal')
                    ->group('Agenda Rapat')
                    ->label('Rapat Terjadwal')
                    ->url(fn(): string => route('filament.app.resources.agenda-rapats.terjadwal'))
                    ->isActiveWhen(fn() => request()->routeIs('filament.app.resources.agenda-rapats.terjadwal')),
                NavigationItem::make('rapat-selesai')
                    ->group('Agenda Rapat')
                    ->label('Rapat Selesai')
                    ->url(fn(): string => route('filament.app.resources.agenda-rapats.selesai'))
                    ->isActiveWhen(fn() => request()->routeIs('filament.app.resources.agenda-rapats.selesai')),
                NavigationItem::make('rapat-pengajuan')
                    ->group('Agenda Rapat')
                    ->visible(function () {
                        $user = Auth::user();
                        return $user->is_guest == "Internal";
                    })
                    ->label('Pengajuan')
                    ->url(fn(): string => route('filament.app.resources.agenda-rapats.pengajuan'))
                    ->isActiveWhen(fn() => request()->routeIs('filament.app.resources.agenda-rapats.pengajuan')),
            ])
            ->navigationGroups([
                NavigationGroup::make()
                    ->label('Agenda Rapat')
                    ->icon('heroicon-o-calendar-date-range')
                    ->collapsed(),
                NavigationGroup::make()
                    ->label('hidden-nav')
                    ->collapsible(false)
                    ->extraSidebarAttributes(['class' => 'hide-group']),
                NavigationGroup::make()
                    ->label('Manajemen Jabatan')
                    ->icon('heroicon-o-identification')
                    ->collapsed(),
                NavigationGroup::make()
                    ->label('hidden-nav-2')
                    ->collapsible(false)
                    ->extraSidebarAttributes(['class' => 'hide-group']),
            ])
            ->middleware([
                EncryptCookies::class,
                AddQueuedCookiesToResponse::class,
                StartSession::class,
                AuthenticateSession::class,
                ShareErrorsFromSession::class,
                VerifyCsrfToken::class,
                SubstituteBindings::class,
                DisableBladeIconComponents::class,
                DispatchServingFilamentEvent::class,
            ])
            ->authMiddleware([
                Authenticate::class,
            ])
            ->plugins([
                \BezhanSalleh\FilamentShield\FilamentShieldPlugin::make(),
            ]);
    }
}
