<?php

namespace App\Policies;

use App\Models\User;
use App\Models\AgendaRapat;
use Illuminate\Auth\Access\HandlesAuthorization;

class AgendaRapatPolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the user can view any models.
     */
    public function viewAny(User $user): bool
    {
        return $user->can('view_any_agenda::rapat');
    }

    /**
     * Determine whether the user can view the model.
     */
    public function view(User $user, AgendaRapat $agendaRapat): bool
    {
        return $user->can('view_agenda::rapat');
    }

    /**
     * Determine whether the user can create models.
     */
    public function create(User $user): bool
    {
        return $user->can('create_agenda::rapat');
    }

    /**
     * Determine whether the user can update the model.
     */
    public function update(User $user, AgendaRapat $agendaRapat): bool
    {
        return $user->can('update_agenda::rapat');
    }

    /**
     * Determine whether the user can delete the model.
     */
    public function delete(User $user, AgendaRapat $agendaRapat): bool
    {
        return $user->can('delete_agenda::rapat');
    }

    /**
     * Determine whether the user can bulk delete.
     */
    public function deleteAny(User $user): bool
    {
        return $user->can('delete_any_agenda::rapat');
    }

    /**
     * Determine whether the user can permanently delete.
     */
    public function forceDelete(User $user, AgendaRapat $agendaRapat): bool
    {
        return $user->can('force_delete_agenda::rapat');
    }

    /**
     * Determine whether the user can permanently bulk delete.
     */
    public function forceDeleteAny(User $user): bool
    {
        return $user->can('force_delete_any_agenda::rapat');
    }

    /**
     * Determine whether the user can restore.
     */
    public function restore(User $user, AgendaRapat $agendaRapat): bool
    {
        return $user->can('restore_agenda::rapat');
    }

    /**
     * Determine whether the user can bulk restore.
     */
    public function restoreAny(User $user): bool
    {
        return $user->can('restore_any_agenda::rapat');
    }

    /**
     * Determine whether the user can replicate.
     */
    public function replicate(User $user, AgendaRapat $agendaRapat): bool
    {
        return $user->can('replicate_agenda::rapat');
    }

    /**
     * Determine whether the user can reorder.
     */
    public function reorder(User $user): bool
    {
        return $user->can('reorder_agenda::rapat');
    }

    /**
     * Determine whether the user can persetujuan agenda rapat.
     */
    public function persetujuan(User $user)
    {
        return $user->can('persetujuan_agenda::rapat');
    }

    /**
     * Determine whether the user can backdate agenda rapat.
     */
    public function backdate(User $user)
    {
        return $user->can('backdate_agenda::rapat');
    }

    /**
     * Determine whether the user can edit Hasil Rapat agenda rapat.
     */
    public function editHasilRapat(User $user)
    {
        return $user->can('edit_hasil_rapat_agenda::rapat');
    }

    /**
     * Determine whether the user can lihat Hasil Rapat agenda rapat.
     */
    public function lihatHasilRapat(User $user)
    {
        return $user->can('lihat_hasil_rapat_agenda::rapat');
    }
}
