<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;

class TlRapat extends Model
{
    use HasFactory, SoftDeletes;
    protected $fillable = [
        'hasil_rapat_id',
        'agenda_rapat_id',
        'user_id',
        'target',
        'tanggapan',
        'alasan_ditolak',
        'status',
    ];

    public function HasilRapat()
    {
        return $this->belongsTo(HasilRapat::class);
    }
    public function AgendaRapat()
    {
        return $this->belongsTo(AgendaRapat::class);
    }
    public function user()
    {
        return $this->belongsTo(User::class);
    }
    public function dokumen()
    {
        return $this->hasMany(FileTl::class);
    }
}
