<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;

class PesertaRapat extends Model
{
    use HasFactory;
    protected $fillable = [
        'agenda_rapat_id',
        'user_id',
        'status',
    ];
    public function agendaRapat()
    {
        return $this->belongsTo(AgendaRapat::class);
    }
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }
}
