<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class HasilRapat extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'agenda_rapat_id',
        'foto_rapat',
        'risalah_rapat',
        'deskripsi',
    ];

    public function agendaRapat()
    {
        return $this->belongsTo(AgendaRapat::class);
    }
    public function TindakLanjut()
    {
        return $this->hasMany(TlRapat::class);
    }
    public function dokumen()
    {
        return $this->hasMany(DokumenHasilRapat::class);
    }
    public function foto()
    {
        return $this->hasMany(FotoHasilRapat::class);
    }
}
