<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class FotoHasilRapat extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'hasil_rapat_id',
        'foto',
    ];

    public function HasilRapat()
    {
        return $this->belongsTo(HasilRapat::class, 'hasil_rapat_id');
    }
    public function getFotoUrlAttribute()
    {
        return $this->foto ? asset('storage/' . $this->foto) : null;
    }
}
