<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class DokumenHasilRapat extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'hasil_rapat_id',
        'name',
        'dokumen',
    ];

    public function HasilRapat()
    {
        return $this->belongsTo(HasilRapat::class, 'hasil_rapat_id');
    }
    public function getDokumenUrlAttribute()
    {
        return $this->dokumen ? asset('storage/' . $this->dokumen) : null;
    }
}
