<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;

class AgendaRapat extends Model
{
    use HasFactory, SoftDeletes;
    protected $fillable = [
        'judul',
        'tanggal',
        'agenda',
        'mulai',
        'selesai',
        'ruangan_id',
        'status',
        'tindak_lanjut',
        'alasan_ditolak',
        'keterangan',
        'pic',
        'notulen',
        'klasifikasi_rapat',
        'pelaksanaan',
        'tl_rapat_id',
        'hasil_rapat_id',
        'user_id',
        'bahan_rapat',
        'link',
        'nomer',
        'accepted'
    ];
    public function creator()
    {
        return $this->belongsTo(User::class, 'user_id');
    }
    public function ruangan()
    {
        return $this->belongsTo(Ruangan::class);
    }
    public function PesertaRapat(): HasMany
    {
        return $this->hasMany(PesertaRapat::class);
    }
    public function TamuRapat(): HasMany
    {
        return $this->hasMany(TamuRapat::class);
    }
    public function Perwakilan(): HasMany
    {
        return $this->hasMany(Perwakilan::class);
    }
    public function HasilRapat()
    {
        return $this->hasOne(HasilRapat::class);
    }
    public function TlRapat()
    {
        return $this->hasMany(TlRapat::class);
    }
    public function Users()
    {
        return $this->hasManyThrough(User::class, PesertaRapat::class);
    }

    public function Penanggungjawab()
    {
        return $this->belongsTo(User::class, 'pic', 'id');
    }
    public function Notulensi()
    {
        return $this->belongsTo(User::class, 'notulen', 'id');
    }
    public function Log()
    {
        return $this->hasMany(Log::class);
    }
}
