<?php

namespace App\Filament\App\Widgets;

use App\Models\AgendaRapat;
use Filament\Tables;
use Filament\Tables\Table;
use Filament\Widgets\TableWidget as BaseWidget;

class RapatMendatang extends BaseWidget
{
    protected int | string | array $columnSpan = 'full';

    public function table(Table $table): Table
    {
        return $table
            ->query(
                AgendaRapat::where('tanggal', '>=', now())->take(10)
            )
            ->columns([
                Tables\Columns\TextColumn::make('judul')
                    // ->weight(FontWeight::Bold)
                    // ->size('lg')
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: false)
                    ->searchable(),
                Tables\Columns\TextColumn::make('status')
                    ->badge()
                    ->searchable()
                    ->toggleable(isToggledHiddenByDefault: false)
                    ->color(fn(string $state): string => match ($state) {
                        'Draft' => 'gray',
                        'Pengajuan' => 'warning',
                        'Terjadwal' => 'info',
                        'Ditolak' => 'danger',
                        'Selesai' => 'success',
                    }),
                Tables\Columns\TextColumn::make('tindak_lanjut')
                    ->badge()
                    ->toggleable(isToggledHiddenByDefault: false)
                    ->color(fn(string $state): string => match ($state) {
                        'Belum' => 'gray',
                        'Menunggu' => 'info',
                        'Review' => 'warning',
                        'Selesai' => 'success',
                    }),
                Tables\Columns\TextColumn::make('pelaksanaan')
                    ->searchable()
                    ->toggleable(isToggledHiddenByDefault: false)
                    ->badge()
                    ->color(fn(string $state): string => match ($state) {
                        'Daring' => 'violet',
                        'Luring' => 'sky',
                        'Hybrid' => 'fuchsia',
                    }),
                Tables\Columns\TextColumn::make('ruangan.name')
                    ->icon('heroicon-o-building-office-2')
                    ->label('Ruangan')
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: false)
                    ->searchable(),
                Tables\Columns\TextColumn::make('tanggal')
                    ->icon('heroicon-o-calendar-days')
                    ->date('d-m-Y')
                    ->toggleable(isToggledHiddenByDefault: false)
                    ->sortable(),
                Tables\Columns\TextColumn::make('mulai')
                    ->icon('heroicon-o-clock')
                    ->time('H:i')
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: false),
                Tables\Columns\TextColumn::make('selesai')
                    ->icon('heroicon-o-clock')
                    ->time('H:i')
                    ->toggleable(isToggledHiddenByDefault: false)
                    ->sortable(),
                Tables\Columns\TextColumn::make('Penanggungjawab.name')
                    ->label('Penanggung Jawab')
                    ->default('-')
                    ->toggleable(isToggledHiddenByDefault: false)
                    ->searchable(),
                Tables\Columns\TextColumn::make('keterangan')
                    ->limit(50)
                    ->default('-')
                    ->toggleable(isToggledHiddenByDefault: true)
                    ->formatStateUsing(function ($state, $record) {
                        if ($record->status == 'Ditolak') {
                            return '';
                        }
                        return $state;
                    })
                    ->tooltip(function (Tables\Columns\TextColumn $column): ?string {
                        $state = $column->getState();

                        if (strlen($state) <= $column->getCharacterLimit()) {
                            return null;
                        }

                        // Only render the tooltip if the column content exceeds the length limit.
                        return $state;
                    })
            ]);
    }
}
