<?php

namespace App\Filament\App\Resources\TlRapatResource\Pages;

use App\Filament\App\Resources\TlRapatResource;
use App\Models\AgendaRapat;
use App\Models\Log;
use App\Models\TlRapat;
use App\Models\User;
use Filament\Actions;
use Filament\Resources\Pages\EditRecord;
use Illuminate\Support\Facades\Auth;

class EditTlRapat extends EditRecord
{
    protected static string $resource = TlRapatResource::class;

    protected static ?string $title = 'Tindak Lanjut Rapat';

    protected function getHeaderActions(): array
    {
        return [
            Actions\Action::make('Kembali')
                ->url(function () {
                    return route('filament.app.resources.tl-rapats.index');
                })
                ->button()
                ->color('info'),
        ];
    }
    protected function mutateFormDataBeforeSave(array $data): array
    {
        $userId = Auth::user()->id;
        $recordUser =  $data['user_id'];
        $agendaRapatId = $data['agenda_rapat_id'];
        if ($userId == $recordUser) {
            $data['status'] = "Pengajuan";
        }

        // Ambil semua data dengan hasil_rapat_id ==  $data['hasil_rapat_id']
        $list = TlRapat::where('hasil_rapat_id',  $data['hasil_rapat_id'])->get();

        // Cek apakah semua data memiliki status == "Pengajuan"
        $semuaPengajuan = $list->every(function ($item) use ($userId, $recordUser) {
            if ($userId == $item->user_id) {
                return true;
            }
            return $item->status === 'Pengajuan';
        });

        Log::create([
            'agenda_rapat_id' => $agendaRapatId,
            'user_id' => $userId,
            'log' => "Tindak lanjut diedit",
        ]);

        // Kalau benar, kasih alert berhasil
        if ($semuaPengajuan) {
            AgendaRapat::where('id', $agendaRapatId)->update(['tindak_lanjut' => 'Review']);
        } else {
            AgendaRapat::where('id',  $agendaRapatId)->update(['tindak_lanjut' => 'Menunggu']);
        }
        return $data;
    }

    protected function getRedirectUrl(): string
    {
        return $this->getResource()::getUrl('index');
    }
}
