<?php

namespace App\Filament\App\Resources\PesanResource\Pages;

use App\Filament\App\Resources\PesanResource;
use App\Mail\KirimPesan;
use App\Models\User;
use Exception;
use Filament\Actions;
use Filament\Resources\Pages\CreateRecord;
use Illuminate\Support\Facades\Mail;

class CreatePesan extends CreateRecord
{
    protected static string $resource = PesanResource::class;

    protected function mutateFormDataBeforeCreate(array $data): array
    {
        $email = User::where('id', $data['user_id'])->first()->email;

        try {
            // kirim email
            Mail::to($email)->send(
                new KirimPesan([
                    'type' => $data['type'],
                    'title' => $data['title'],
                    'body' => $data['body'],
                    'action' => $data['action'],
                ])
            );
        } catch (Exception $ex) {
        }
        return $data;
    }
}
