<?php

namespace App\Filament\App\Resources\AgendaRapatResource\RelationManagers;

use App\Models\AgendaRapat;
use App\Models\User;
use App\Models\Departemen;
use App\Models\Log;
use App\Models\Perwakilan;
use App\Models\Tamu;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Notifications\Notification;
use Filament\Resources\RelationManagers\RelationManager;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletingScope;
use Illuminate\Support\Facades\Auth;
use Livewire\Attributes\On;

class PerwakilanRapatRelationManager extends RelationManager
{
    protected static string $relationship = 'Perwakilan';

    protected static ?string $badgeTooltip = 'Jumlah Perwakilan';

    protected $listeners = ['refreshPerwakilan' => '$refresh'];

    public function form(Form $form): Form
    {
        return $form
            ->schema([]);
    }

    public function table(Table $table): Table
    {
        return $table
            ->recordTitleAttribute('name')
            ->columns([
                Tables\Columns\TextColumn::make('name')
                    ->label('Nama')
                    ->searchable()
                    ->sortable(),
                Tables\Columns\TextColumn::make('user.name')
                    ->label('Perwakilan')
                    ->searchable()
                    ->sortable(),
            ])
            ->filters([
                //
            ])
            ->headerActions([
                $this->TombolSelesaiDanAjukan(),
                // $this->TombolTambahPeserta()
            ])
            ->actions([
                // Tables\Actions\DeleteAction::make(),
            ])
            ->bulkActions([
                // Tables\Actions\BulkActionGroup::make([
                //     Tables\Actions\DeleteBulkAction::make(),
                // ]),
            ]);
    }
    function TombolSelesaiDanAjukan()
    {
        return Tables\Actions\Action::make('Selesai & Ajukan')
            ->label('Selesai & Ajukan')
            ->modalHeading('Konfirmasi Pengajuan')
            ->modalWidth('sm')
            ->requiresConfirmation()
            ->action(function () {
                $agendaRapat = $this->ownerRecord;
                $agendaRapat->update(['status' => 'Pengajuan']);
                $record = $this->ownerRecord;
                Log::create([
                    'agenda_rapat_id' => $record->id,
                    'user_id' => Auth::id(),
                    'log' => "Agenda rapat diajukan",
                ]);
                Notification::make()
                    ->success()
                    ->title('Agenda Rapat Diajukan')
                    ->body('Agenda rapat anda akan review oleh admin')
                    ->send();
            })
            ->requiresConfirmation()
            ->color('success')
            ->hidden(function () {
                $record = $this->ownerRecord;
                if ($record->status == "Draft" || $record->status == "Ditolak") {
                    return false;
                }
                return true;
            });
    }
    public static function getBadge(Model $ownerRecord, string $pageClass): ?string
    {
        $jumlah = Perwakilan::where('agenda_rapat_id', $ownerRecord->id)->count();
        return $jumlah;
    }
}
