<?php

namespace App\Filament\App\Resources\AgendaRapatResource\Pages;

use App\Filament\App\Resources\AgendaRapatResource\RelationManagers;
use App\Filament\App\Resources\AgendaRapatResource;
use App\Models\AgendaRapat;
use Filament\Actions;
use Filament\Resources\Pages\ViewRecord;
use Filament\Infolists\Infolist;
use Filament\Infolists;
use Filament\Support\Enums\FontWeight;
use Filament\Infolists\Components\TextEntry;
use Filament\Infolists\Components\RepeatableEntry;
use Filament\Infolists\Components\Section;

class ViewTindakLanjutAgendaRapat extends ViewRecord
{
    protected static string $resource = AgendaRapatResource::class;
    protected function getHeaderActions(): array
    {
        return [
            Actions\Action::make('Kembali')
                ->url(function () {
                    return url()->previous();
                })
                ->button()
                ->color('info'),
        ];
    }

    protected function getAllRelationManagers(): array
    {
        return [
            RelationManagers\TlRapatRelationManager::class,
        ];
    }

    public function infolist(Infolist $infolist): Infolist
    {
        return $infolist
            ->schema([
                Section::make('Agenda Rapat')
                    ->columns(2)
                    ->schema([
                        Infolists\Components\TextEntry::make('judul')
                            ->view('custom-text')
                            ->label('Judul Rapat'),
                        Infolists\Components\TextEntry::make('pelaksanaan')
                            ->view('custom-text')
                            ->label('Mode Pelaksanaan'),
                        Infolists\Components\TextEntry::make('keterangan')
                            ->view('custom-text')
                            ->columnSpanFull(),
                        Infolists\Components\TextEntry::make('ruangan.name')
                            ->view('custom-text')
                            ->label('Ruangan'),
                        Infolists\Components\TextEntry::make('tanggal')
                            ->view('custom-text')
                            ->label('Tanggal'),
                        Infolists\Components\TextEntry::make('mulai')
                            ->view('custom-text')
                            ->time('H:i')
                            ->label('Waktu Mulai'),
                        Infolists\Components\TextEntry::make('selesai')
                            ->view('custom-text')
                            ->time('H:i')
                            ->label('Waktu Selesai'),
                    ]),
                Section::make('Hasil Rapat')
                    ->columns(2)
                    ->relationship('HasilRapat')
                    ->hidden(function (AgendaRapat $record) {
                        return $record->status != 'Selesai';
                    })
                    ->schema([
                        Infolists\Components\TextEntry::make('risalah_rapat')
                            ->view('custom-text')
                            ->label('Risalah Rapat')
                            ->placeholder('-'),
                        Infolists\Components\TextEntry::make('deskripsi')
                            ->view('custom-text')
                            ->label('Deskripsi')
                            ->placeholder('-'),
                        RepeatableEntry::make('dokumen')
                            ->label('Dokumen Hasil Rapat')
                            ->schema([
                                Infolists\Components\TextEntry::make('name')
                                    ->label('Nama Dokumen')
                                    ->view('custom-text')
                                    ->placeholder('-'),
                                Infolists\Components\TextEntry::make('deskripsi')
                                    ->label('Deskripsi')
                                    ->view('custom-text')
                                    ->placeholder('-'),
                                Infolists\Components\TextEntry::make('')
                                    ->weight(FontWeight::Bold)
                                    ->label('')
                                    ->icon('heroicon-o-document-arrow-down')
                                    ->formatStateUsing(fn(string $state): string => __("Unduh Dokumen"))
                                    ->url(fn($record) => url('/storage/' . $record->dokumen))
                                    ->openUrlInNewTab(),
                            ]),
                        RepeatableEntry::make('foto')
                            ->schema([
                                Infolists\Components\ImageEntry::make('foto')
                                    ->label(''),
                            ]),
                    ]),
            ]);
    }
}
