<?php

namespace App\Filament\App\Resources\AgendaRapatResource\Pages;

use App\Filament\App\Resources\AgendaRapatResource\RelationManagers;
use App\Filament\App\Resources\AgendaRapatResource;
use Filament\Actions;
use Filament\Resources\Pages\ViewRecord;

class ViewLogAgendaRapat extends ViewRecord
{
    protected static string $resource = AgendaRapatResource::class;
    protected function getHeaderActions(): array
    {
        return [
            Actions\Action::make('Kembali')
                ->url(function () {
                    return url()->previous();
                })
                ->button()
                ->color('info'),
        ];
    }

    protected function getAllRelationManagers(): array
    {
        return [
            RelationManagers\LogRelationManager::class,
        ];
    }
}
