<?php

namespace App\Filament\App\Resources\AgendaRapatResource\Pages;

use App\Filament\App\Resources\AgendaRapatResource\RelationManagers;
use App\Filament\App\Resources\AgendaRapatResource;
use App\Models\AgendaRapat;
use App\Models\Log;
use App\Models\Perwakilan;
use App\Models\PesertaRapat;
use App\Models\User;
use Barryvdh\DomPDF\Facade\Pdf;
use Filament\Actions;
use Filament\Resources\Pages\ViewRecord;
use Filament\Infolists\Infolist;
use Filament\Infolists;
use Filament\Support\Enums\FontWeight;
use Filament\Infolists\Components\TextEntry;
use Filament\Notifications\Notification;
use Illuminate\Support\Facades\Auth;
use Filament\Infolists\Components\Section;
use Filament\Forms;

class ViewKonfirmasiAgendaRapat extends ViewRecord
{
    protected static string $resource = AgendaRapatResource::class;
    protected function getHeaderActions(): array
    {
        $AgendaRapat = $this->record;
        $user = User::find(Auth::user()->id);

        return [
            $this->TombolUnduhDaftarHadir($AgendaRapat, $user),
            $this->TombolUnduhUndangan($AgendaRapat, $user),
            Actions\Action::make('Kembali')
                ->url(function () {
                    return url()->previous();
                })
                ->button()
                ->color('info')
        ];
    }


    public function infolist(Infolist $infolist): Infolist
    {
        $undanganPesertaRapat = PesertaRapat::where('user_id', Auth::id())->where('agenda_rapat_id', $infolist->getRecord()->id)->first();
        $belumMemilih = $undanganPesertaRapat->status == 'Belum Dikonfirmasi';
        return $infolist
            ->schema([
                Section::make('Agenda Rapat')
                    ->columns(2)
                    ->schema([
                        Infolists\Components\TextEntry::make('judul')
                            ->view('custom-text')
                            ->label('Judul Rapat')
                            ->columnSpanFull(),
                        Infolists\Components\TextEntry::make('pelaksanaan')
                            ->view('custom-text')
                            ->label('Mode Pelaksanaan'),
                        Infolists\Components\TextEntry::make('link')
                            ->view('custom-text')
                            ->label('Link Rapat')
                            ->formatStateUsing(function ($state) {
                                if ($state != null) {
                                    return $state;
                                }
                                return '-';
                            })
                            ->url(fn($record) => $record->link),
                        Infolists\Components\TextEntry::make('keterangan')
                            ->view('custom-text')
                            ->columnSpanFull(),
                        Infolists\Components\TextEntry::make('ruangan.name')
                            ->view('custom-text')
                            ->label('Ruangan'),
                        Infolists\Components\TextEntry::make('tanggal')
                            ->view('custom-text')
                            ->label('Tanggal'),
                        Infolists\Components\TextEntry::make('mulai')
                            ->view('custom-text')
                            ->time('H:i')
                            ->label('Waktu Mulai'),
                        Infolists\Components\TextEntry::make('selesai')
                            ->view('custom-text')
                            ->time('H:i')
                            ->label('Waktu Selesai'),
                        Infolists\Components\TextEntry::make('Penanggungjawab.name')
                            ->view('custom-text')
                            ->label('Penanggung Jawab'),
                        Infolists\Components\TextEntry::make('Notulensi.name')
                            ->view('custom-text')
                            ->label('Notulen'),
                        Infolists\Components\TextEntry::make('bahan_rapat')
                            ->view('custom-text')
                            ->label('Bahan Rapat')
                            ->icon('heroicon-o-document-arrow-down')
                            ->formatStateUsing(function ($state) {
                                if ($state != null) {
                                    return "Unduh Dokumen";
                                }
                                return '-';
                            })
                            ->url(fn($record) => url('/storage/' . $record->bahan_rapat)),
                    ]),
                Section::make('Konfirmasi Kehadiran')
                    ->label('Konfirmasi Kehadiran')
                    ->schema([
                        Infolists\Components\TextEntry::make('text-confirm')
                            ->label('Konfirmasi apakah anda akan mengikuti rapat ini!')

                    ])
                    ->footerActions([
                        Infolists\Components\Actions\Action::make('informasi')
                            ->disabled()
                            ->visible(!$belumMemilih)
                            ->color(function () use ($undanganPesertaRapat) {
                                if ($undanganPesertaRapat->status == 'Hadir') {
                                    return 'success';
                                }
                                return 'danger';
                            })
                            ->label(function () use ($undanganPesertaRapat) {
                                return 'Anda memilih untuk ' . $undanganPesertaRapat->status . ' ke rapat';
                            }),
                        Infolists\Components\Actions\Action::make('hadir')
                            ->label('Konfirmasi Hadir')
                            ->color('success')
                            ->visible($belumMemilih)
                            ->action(function ($record) use ($undanganPesertaRapat) {
                                $user = User::find(Auth::id());
                                $peserta = PesertaRapat::where('agenda_rapat_id', $record->id)->where('user_id', Auth::id());
                                $peserta->update([
                                    'status' => 'Hadir'
                                ]);
                                Log::create([
                                    'agenda_rapat_id' => $record->id,
                                    'user_id' => Auth::id(),
                                    'log' => "Peserta rapat mengkonfirmasi hadir:" . $user->name,
                                ]);
                                Notification::make()
                                    ->success()
                                    ->title('Berhasil!')
                                    ->body('Anda sudah mengkonfirmasi untuk hadir ke rapat!')
                                    ->send();
                                return redirect()->route('filament.app.resources.agenda-rapats.view', [
                                    'record' => $record->id,
                                ]);
                            }),
                        Infolists\Components\Actions\Action::make('tidak_hadir')
                            ->label('Tidak Hadir')
                            ->color('danger')
                            ->visible($belumMemilih)
                            ->action(function ($record) {
                                $user = User::find(Auth::id());

                                $peserta = PesertaRapat::where('agenda_rapat_id', $record->id)->where('user_id', Auth::id());
                                $peserta->update([
                                    'status' => 'Tidak Hadir'
                                ]);
                                Log::create([
                                    'agenda_rapat_id' => $record->id,
                                    'user_id' => Auth::id(),
                                    'log' => "Peserta rapat mengkonfirmasi absen: " . $user->name,
                                ]);
                                Notification::make()
                                    ->success()
                                    ->title('Berhasil!')
                                    ->body('Anda sudah mengkonfirmasi untuk tidak hadir ke rapat!')
                                    ->send();
                                return redirect()->route('filament.app.resources.agenda-rapats.view', [
                                    'record' => $record->id,
                                ]);
                            }),
                        Infolists\Components\Actions\Action::make('perwakilan')
                            ->modalWidth('md')
                            ->label('Perwakilan Hadir')
                            ->color('warning')
                            ->visible($belumMemilih)
                            ->form([
                                Forms\Components\TextInput::make('name')
                                    ->label('Nama Perwakilan')
                                    ->required()
                                    ->placeholder('Masukkan nama')
                                    ->columnSpanFull(),
                            ])
                            ->action(function (array $data, $record) {
                                $user = User::find(Auth::id());
                                $user_id = $user->id;
                                $peserta = PesertaRapat::where('agenda_rapat_id', $record->id)->where('user_id', $user_id);
                                $peserta->update([
                                    'status' => 'Diwakilkan'
                                ]);
                                Log::create([
                                    'agenda_rapat_id' => $record->id,
                                    'user_id' => Auth::id(),
                                    'log' => "Peserta rapat mengkonfirmasi perwakilan",
                                ]);
                                Log::create([
                                    'agenda_rapat_id' => $record->agenda_rapat_id,
                                    'user_id' => Auth::id(),
                                    'log' => "Peserta rapat mengkonfirmasi perwakilan: " . $user->name . " oleh :" . $data['name'],
                                ]);

                                Perwakilan::create([
                                    'agenda_rapat_id' => $record->id,
                                    'user_id' => $user_id,
                                    'name' => $data['name']
                                ]);
                                Notification::make()
                                    ->success()
                                    ->title('Berhasil!')
                                    ->body('Anda sudah mengkonfirmasi untuk mewakilkan ke rapat!')
                                    ->send();
                                return redirect()->route('filament.app.resources.agenda-rapats.view', [
                                    'record' => $record->id,
                                ]);
                            })
                    ]),
            ]);
    }

    function  TombolUnduhDaftarHadir($AgendaRapat, $user)
    {
        return Actions\Action::make('Daftar Hadir')
            ->color('warning')
            ->icon('heroicon-o-document-arrow-down')
            ->hidden(function () use ($AgendaRapat) {
                if ($AgendaRapat->status == "Draft" || $AgendaRapat->status == 'Ditolak' || $AgendaRapat->status == 'Pengajuan') {
                    return true;
                }
                return false;
            })
            ->action(function () use ($AgendaRapat) {

                $rapat = AgendaRapat::where('id', $AgendaRapat->id)
                    ->with('ruangan')
                    ->first();

                $pesertaRapat = $AgendaRapat->PesertaRapat()
                    ->with('user')
                    ->with('user.departemen')
                    ->get();

                $pdf = Pdf::loadView('daftarhadir', ['agendaRapat' => $rapat, 'pesertaRapat' => $pesertaRapat]);
                $pdf->setPaper('A4', 'potrait');
                return response()->streamDownload(function () use ($pdf) {
                    echo $pdf->stream();
                }, 'Daftar hadir rapat ' . $rapat->judul . '.pdf');
            });
    }
    function TombolUnduhUndangan($AgendaRapat, $user)
    {
        return Actions\Action::make('Undangan')
            ->color('warning')
            ->icon('heroicon-o-document-arrow-down')
            ->hidden(function () use ($AgendaRapat) {
                if ($AgendaRapat->status == "Draft" || $AgendaRapat->status == 'Ditolak' || $AgendaRapat->status == 'Pengajuan') {
                    return true;
                }
                return false;
            })
            ->action(function () use ($AgendaRapat) {

                $rapat = AgendaRapat::where('id', $AgendaRapat->id)
                    ->with('ruangan')
                    ->first();

                $pesertaRapat = $AgendaRapat->PesertaRapat()
                    ->with('user')
                    ->with('user.departemen')
                    ->get();

                $creator = $AgendaRapat->creator;
                $departemen = $creator->departemen;

                $pdf = Pdf::loadView('undangan', ['agendaRapat' => $rapat, 'creator' => $creator, 'pesertaRapat' => $pesertaRapat, 'departemen' => $departemen]);
                $pdf->setPaper('A4', 'potrait');
                return response()->streamDownload(function () use ($pdf) {
                    echo $pdf->stream();
                }, 'Undangan rapat.pdf');
            });
    }
}
