<?php

namespace App\Filament\App\Resources\AgendaRapatResource\Pages;

use App\Filament\App\Resources\AgendaRapatResource;
use App\Models\AgendaRapat;
use App\Models\User;
use Filament\Actions;
use Filament\Resources\Pages\ListRecords;
use Illuminate\Support\Facades\Auth;
use Illuminate\Database\Eloquent\Builder;
use Barryvdh\DomPDF\Facade\Pdf;
use Filament\Forms;
use Filament\Resources\Components\Tab;
use Filament\Tables\Table;

class RapatTerjadwal extends ListRecords
{
    protected static string $resource = AgendaRapatResource::class;
    protected static string $view = 'filament.app.pages.list-records';

    protected function getHeaderActions(): array
    {
        return [
            Actions\Action::make('Download')
                ->color('warning')
                ->icon('heroicon-o-document-arrow-down')
                ->modalWidth('md')
                ->modalSubmitActionLabel('Unduh')
                ->visible(function () {
                    return Auth::user()->is_guest == "Internal";
                })
                ->form([
                    Forms\Components\Split::make([
                        Forms\Components\DatePicker::make('tanggal')
                            ->displayFormat('d/m/Y')
                            ->native(false)
                            ->required(),
                        Forms\Components\DatePicker::make('sampai')
                            ->displayFormat('d/m/Y')
                            ->native(false)
                            ->required()
                    ]),
                ])->action(function (array $data) {

                    $tanggal = $data['tanggal'];
                    $sampai = $data['sampai'];

                    $agendaRapats = AgendaRapat::whereBetween('tanggal', [$tanggal, $sampai])
                        ->with('PesertaRapat.user')
                        ->with('TamuRapat.tamu')
                        ->with('Perwakilan.user')
                        ->with('ruangan')
                        ->orderBy('tanggal', 'asc')
                        ->get();

                    $pdf = Pdf::loadView('laporan', ['agendaRapats' => $agendaRapats]);
                    $pdf->setPaper('A4', 'landscape');
                    return response()->streamDownload(function () use ($pdf) {
                        echo $pdf->stream();
                    }, 'laporan_agenda_rapat.pdf');
                }),
            Actions\CreateAction::make(),

        ];
    }

    public function table(Table $table): Table
    {
        $user = Auth::user();
        $userIsExternal = $user->is_guest == "External";

        return static::getResource()::table($table)
            ->modifyQueryUsing(function (Builder $query) use ($user, $userIsExternal) {
                if ($userIsExternal) {
                    return $query->where('status', 'Terjadwal')
                        ->whereHas('PesertaRapat', function (Builder $query) use ($user) {
                            $query->where('user_id', $user->id);
                        });
                } else {
                    return $query->where('status', 'Terjadwal');
                }
            });
    }
}
