<?php

namespace App\Filament\App\Resources\AgendaRapatResource\Pages;

use App\Filament\App\Resources\AgendaRapatResource;
use App\Models\AgendaRapat;
use App\Models\User;
use Filament\Actions;
use Filament\Resources\Pages\ListRecords;
use Illuminate\Support\Facades\Auth;
use Illuminate\Database\Eloquent\Builder;
use Barryvdh\DomPDF\Facade\Pdf;
use Filament\Actions\Contracts\HasRecord;
use Filament\Forms;
use Filament\Resources\Components\Tab;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Model;

class RapatPengajuan extends ListRecords
{
    protected static string $resource = AgendaRapatResource::class;
    protected static string $view = 'filament.app.pages.list-records';

    protected function getHeaderActions(): array
    {
        return [
            Actions\Action::make('Download')
                ->color('warning')
                ->icon('heroicon-o-document-arrow-down')
                ->modalWidth('md')
                ->modalSubmitActionLabel('Unduh')
                ->visible(function () {
                    return Auth::user()->is_guest == "Internal";
                })
                ->form([
                    Forms\Components\Split::make([
                        Forms\Components\DatePicker::make('tanggal')
                            ->displayFormat('d/m/Y')
                            ->native(false)
                            ->required(),
                        Forms\Components\DatePicker::make('sampai')
                            ->displayFormat('d/m/Y')
                            ->native(false)
                            ->required()
                    ]),
                ])->action(function (array $data) {

                    $tanggal = $data['tanggal'];
                    $sampai = $data['sampai'];

                    $agendaRapats = AgendaRapat::whereBetween('tanggal', [$tanggal, $sampai])
                        ->with('PesertaRapat.user')
                        ->with('TamuRapat.tamu')
                        ->with('Perwakilan.user')
                        ->with('ruangan')
                        ->orderBy('tanggal', 'asc')
                        ->get();

                    $pdf = Pdf::loadView('laporan', ['agendaRapats' => $agendaRapats]);
                    $pdf->setPaper('A4', 'landscape');
                    return response()->streamDownload(function () use ($pdf) {
                        echo $pdf->stream();
                    }, 'laporan_agenda_rapat.pdf');
                }),
            Actions\CreateAction::make(),

        ];
    }

    public function table(Table $table): Table
    {
        $user = Auth::user();
        //return static::getResource()::table($table);

        return static::getResource()::table($table)
            ->recordUrl($this->getTableRecordUrlUsing() ?? function (Model $record, Table $table): ?string {
                foreach (['edit', 'view'] as $action) {
                    $action = $table->getAction($action);

                    if (! $action) {
                        continue;
                    }

                    $action->record($record);

                    if (($actionGroup = $action->getGroup()) instanceof HasRecord) {
                        $actionGroup->record($record);
                    }

                    if ($action->isHidden()) {
                        continue;
                    }

                    $url = $action->getUrl();

                    if (! $url) {
                        continue;
                    }

                    return $url;
                }

                $resource = static::getResource();

                foreach (['edit', 'view'] as $action) {
                    if (! $resource::hasPage($action)) {
                        continue;
                    }

                    if (! $resource::{'can' . ucfirst($action)}($record)) {
                        continue;
                    }

                    return $resource::getUrl($action, ['record' => $record]);
                }

                return null;
            })
            ->modifyQueryUsing(function (Builder $query) {
                $user = User::find(Auth::user()->id);

                // Check if the user has the permission
                // If the user has the permission, show all records
                // If the user does not have the permission, show only records created by the user
                if ($user->can('persetujuan_agenda::rapat')) {
                    return $query->where(function ($query) use ($user) {
                        $query->where('status', 'Pengajuan')
                            ->orWhere(function ($query) use ($user) {
                                $query->where('user_id', $user->id)
                                    ->whereIn('status', ['Draft', 'Pengajuan', 'Ditolak']);
                            });
                    });
                } else {
                    return $query->where('user_id', $user->id)
                        ->whereIn('status', ['Draft', 'Pengajuan', 'Ditolak']);
                }
            });
    }
}
