<?php

namespace App\Filament\App\Resources\AgendaRapatResource\Pages;

use App\Filament\App\Resources\AgendaRapatResource;
use App\Models\AgendaRapat;
use Filament\Actions;
use Filament\Resources\Pages\ListRecords;
use Filament\Resources\Components\Tab;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Support\Facades\Auth;
use App\Models\User;
use Filament\Forms;
use Filament\Forms\Form;
use Barryvdh\DomPDF\Facade\Pdf;

class ListAgendaRapats extends ListRecords
{
    protected static string $resource = AgendaRapatResource::class;
    protected static string $view = 'filament.app.pages.list-records';


    protected function getHeaderActions(): array
    {
        return [
            Actions\Action::make('Download')
                ->color('warning')
                ->icon('heroicon-o-document-arrow-down')
                ->modalWidth('md')
                ->modalSubmitActionLabel('Unduh')
                ->visible(function () {
                    return Auth::user()->is_guest == "Internal";
                })
                ->form([
                    Forms\Components\Split::make([
                        Forms\Components\DatePicker::make('tanggal')
                            ->displayFormat('d/m/Y')
                            ->native(false)
                            ->required(),
                        Forms\Components\DatePicker::make('sampai')
                            ->displayFormat('d/m/Y')
                            ->native(false)
                            ->required()
                    ]),
                ])->action(function (array $data) {

                    $tanggal = $data['tanggal'];
                    $sampai = $data['sampai'];

                    $agendaRapats = AgendaRapat::whereBetween('tanggal', [$tanggal, $sampai])
                        ->with('PesertaRapat.user')
                        ->with('TamuRapat.tamu')
                        ->with('Perwakilan.user')
                        ->with('ruangan')
                        ->orderBy('tanggal', 'asc')
                        ->get();

                    $pdf = Pdf::loadView('laporan', ['agendaRapats' => $agendaRapats]);
                    $pdf->setPaper('A4', 'landscape');
                    return response()->streamDownload(function () use ($pdf) {
                        echo $pdf->stream();
                    }, 'laporan_agenda_rapat.pdf');
                }),
            Actions\CreateAction::make(),

        ];
    }
    // public function getTabs(): array
    // {
    //     $user = Auth::user();
    //     $userIsExternal = $user->is_guest == "External";
    //     if ($userIsExternal) {
    //         return [
    //             'Rapat Terjadwal' => Tab::make()
    //                 ->modifyQueryUsing(function (Builder $query) use ($user) {
    //                     return $query->where('status', 'Terjadwal')
    //                         ->whereHas('PesertaRapat', function (Builder $query) use ($user) {
    //                             $query->where('user_id', $user->id);
    //                         });
    //                 }),
    //             'Rapat Selesai' => Tab::make()
    //                 ->modifyQueryUsing(function (Builder $query) use ($user) {
    //                     return $query->where('status', 'Selesai')
    //                         ->whereHas('PesertaRapat', function (Builder $query) use ($user) {
    //                             $query->where('user_id', $user->id);
    //                         });
    //                 }),
    //         ];
    //     }
    //     return [
    //         'Rapat Terjadwal' => Tab::make()
    //             ->modifyQueryUsing(function (Builder $query) {
    //                 return $query->where('status', 'Terjadwal');
    //             }),
    //         'Rapat Selesai' => Tab::make()
    //             ->modifyQueryUsing(function (Builder $query) {
    //                 return $query->orWhere('status', 'Selesai');
    //             }),
    //         'Pengajuan' => Tab::make()
    //             ->modifyQueryUsing(function (Builder $query) {
    //                 $user = User::find(Auth::user()->id);

    //                 // Check if the user has the permission
    //                 // If the user has the permission, show all records
    //                 // If the user does not have the permission, show only records created by the user
    //                 if ($user->can('persetujuan_agenda::rapat')) {
    //                     return $query->where(function ($query) use ($user) {
    //                         $query->where('status', 'Pengajuan')
    //                             ->orWhere(function ($query) use ($user) {
    //                                 $query->where('user_id', $user->id)
    //                                     ->whereIn('status', ['Draft', 'Pengajuan', 'Ditolak']);
    //                             });
    //                     });
    //                 } else {
    //                     return $query->where('user_id', $user->id)
    //                         ->whereIn('status', ['Draft', 'Pengajuan', 'Ditolak']);
    //                 }
    //             }),
    //     ];
    // }
}
