<?php

namespace App\Filament\App\Resources\AgendaRapatResource\Pages;

use App\Filament\App\Resources\AgendaRapatResource\RelationManagers;
use App\Filament\App\Resources\AgendaRapatResource;
use App\Models\Log;
use App\Models\Perwakilan;
use App\Models\PesertaRapat;
use App\Models\Tamu;
use App\Models\TamuRapat;
use App\Models\User;
use Filament\Actions;
use Filament\Notifications\Notification;
use Filament\Resources\Pages\EditRecord;
use Illuminate\Support\Facades\Auth;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Http\Request;

class EditAgendaRapat extends EditRecord
{
    protected static string $resource = AgendaRapatResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Actions\Action::make('Kembali')
                ->url(function () {
                    return route('filament.app.resources.agenda-rapats.pengajuan');
                })
                ->button()
                ->color('info'),
            Actions\DeleteAction::make(),
        ];
    }


    protected function mutateFormDataBeforeSave(array $data): array
    {
        $currentuser = User::find(Auth::id());
        $agendaRapat = $this->record;

        if ($agendaRapat->user_id == $currentuser->id) {
            $data['status'] = "Draft";
        } else {
            $data['status'] = "Pengajuan";
        }

        //update notulen rapat
        $notulenRapat = PesertaRapat::where('agenda_rapat_id', $agendaRapat->id)->where('user_id', $agendaRapat->notulen);
        $notulenRapat->update([
            'user_id' => $data['notulen'],
            'status' => 'Belum Dikonfirmasi',
        ]);

        //update pic rapat
        $pesertaRapat = PesertaRapat::where('agenda_rapat_id', $agendaRapat->id)->where('user_id', $agendaRapat->pic);
        $pesertaRapat->update([
            'user_id' => $data['pic'],
            'status' => 'Belum Dikonfirmasi',
        ]);

        $this->CekPeserta($agendaRapat);
        $this->CekTamu($agendaRapat);

        $record = $this->record;
        Log::create([
            'agenda_rapat_id' => $record->id,
            'user_id' => Auth::id(),
            'log' => "Agenda rapat diubah",
        ]);

        return $data;
    }
    protected function getRedirectUrl(): string
    {
        $currentuser = User::find(Auth::id());
        $agendaRapat = $this->record;
        // if ($agendaRapat->user_id == $currentuser->id) {
        //     return route('filament.app.resources.agenda-rapats.view', ['record' => $agendaRapat->id]);
        // }
        return route('filament.app.resources.agenda-rapats.view', ['record' => $agendaRapat->id]);
        //return route('filament.app.resources.agenda-rapats.edit', ['record' => $agendaRapat->id]);
    }

    protected function getAllRelationManagers(): array
    {
        return [
            RelationManagers\PesertaRapatRelationManager::class,
            RelationManagers\TamuRapatRelationManager::class,
        ];
    }

    function CekPeserta($agendaRapat)
    {
        $pesertaRapat = PesertaRapat::where('agenda_rapat_id', $agendaRapat->id)->pluck('user_id')->toArray();
        PesertaRapat::where('agenda_rapat_id', $agendaRapat->id)->delete();

        $listUserOverlap = "";
        foreach ($pesertaRapat as $peserta) {

            $overlapping = \App\Models\PesertaRapat::where('user_id', $peserta)
                ->whereHas('agendaRapat', function (Builder $query) use ($agendaRapat) {
                    $query->where('tanggal', $agendaRapat->tanggal)
                        ->where(function (Builder $query) use ($agendaRapat) {
                            $query->whereBetween('mulai', [$agendaRapat->mulai, $agendaRapat->selesai])
                                ->orWhereBetween('selesai', [$agendaRapat->mulai, $agendaRapat->selesai])
                                ->orWhere(function (Builder $query) use ($agendaRapat) {
                                    $query->where('mulai', '<=', $agendaRapat->mulai)
                                        ->where('selesai', '>=', $agendaRapat->selesai);
                                });
                        });
                })
                ->exists();

            if ($overlapping) {
                $listUserOverlap .= User::find($peserta)->name . ", ";
                continue;
            }


            PesertaRapat::create([
                'user_id' => $peserta,
                'agenda_rapat_id' => $agendaRapat->id,
                'status' => 'Belum Dikonfirmasi',
            ]);
        }
        $record = $this->record;
        Log::create([
            'agenda_rapat_id' => $record->id,
            'user_id' => Auth::id(),
            'log' => "Menambahkan peserta rapat",
        ]);
        if ($listUserOverlap != "") {
            Notification::make()
                ->danger()
                ->title('Peserta mengikuti rapat lain!')
                ->body('Terdapat peserta yang tidak bisa ditambahkan: ' . $listUserOverlap)
                ->send();
        }
    }
    function CekTamu($agendaRapat)
    {
        $TamuRapat = TamuRapat::where('agenda_rapat_id', $agendaRapat->id)->pluck('tamu_id')->toArray();
        TamuRapat::where('agenda_rapat_id', $agendaRapat->id)->delete();

        Perwakilan::where('agenda_rapat_id', $agendaRapat->id)->delete();

        $listUserOverlap = "";
        foreach ($TamuRapat as $peserta) {

            $overlapping = \App\Models\TamuRapat::where('tamu_id', $peserta)
                ->whereHas('agendaRapat', function (Builder $query) use ($agendaRapat) {
                    $query->where('tanggal', $agendaRapat->tanggal)
                        ->where(function (Builder $query) use ($agendaRapat) {
                            $query->whereBetween('mulai', [$agendaRapat->mulai, $agendaRapat->selesai])
                                ->orWhereBetween('selesai', [$agendaRapat->mulai, $agendaRapat->selesai])
                                ->orWhere(function (Builder $query) use ($agendaRapat) {
                                    $query->where('mulai', '<=', $agendaRapat->mulai)
                                        ->where('selesai', '>=', $agendaRapat->selesai);
                                });
                        });
                })
                ->exists();

            if ($overlapping) {
                $listUserOverlap .= Tamu::find($peserta)->name . ", ";
                continue;
            }

            TamuRapat::create([
                'tamu_id' => $peserta,
                'agenda_rapat_id' => $agendaRapat->id,
            ]);
        }
        $record = $this->record;
        Log::create([
            'agenda_rapat_id' => $record->id,
            'user_id' => Auth::id(),
            'log' => "Menambahkan tamu rapat",
        ]);
        if ($listUserOverlap != "") {
            Notification::make()
                ->danger()
                ->title('Tamu mengikuti rapat lain!')
                ->body('Terdapat tamu yang tidak bisa ditambahkan: ' . $listUserOverlap)
                ->send();
        }
    }
}
