<?php

namespace App\Filament\App\Resources\AgendaRapatResource\Pages;

use App\Filament\App\Resources\AgendaRapatResource;
use App\Models\Log;
use App\Models\PesertaRapat;
use Filament\Actions;
use Filament\Resources\Pages\CreateRecord;
use Illuminate\Support\Facades\Auth;

class CreateAgendaRapat extends CreateRecord
{
    protected static string $resource = AgendaRapatResource::class;

    protected function getHeaderActions(): array
    {
        return [
            Actions\Action::make('Kembali')
                ->url(function () {
                    return route('filament.app.resources.agenda-rapats.pengajuan');
                })
                ->button()
                ->color('info'),
        ];
    }

    protected function mutateFormDataBeforeCreate(array $data): array
    {
        $data['status'] = "Draft";
        $data['user_id'] = Auth::id();
        return $data;
    }

    protected function afterCreate(): void
    {
        $record = $this->record;
        Log::create([
            'agenda_rapat_id' => $record->id,
            'user_id' => Auth::id(),
            'log' => "Agenda rapat dibuat",
        ]);
        PesertaRapat::create([
            'agenda_rapat_id' => $record->id,
            'user_id' => $record->pic,
            'status' => 'Belum Dikonfirmasi',
        ]);
        PesertaRapat::create([
            'agenda_rapat_id' => $record->id,
            'user_id' => $record->notulen,
            'status' => 'Belum Dikonfirmasi',
        ]);
    }
    protected function getRedirectUrl(): string
    {
        $resource = static::getResource();

        if ($resource::hasPage('edit') && $resource::canEdit($this->getRecord())) {
            return $resource::getUrl('edit', ['record' => $this->getRecord(), ...$this->getRedirectUrlParameters()]);
        }

        return $resource::getUrl('index');
    }
}
